using System;
using System.Collections.Generic;
using System.Numerics;

class Program
{
    static void Main()
    {
        int T = int.Parse(Console.ReadLine());
        for (int t = 0; t < T; t++)
        {
            string n = Console.ReadLine();
            var produkt = new HashSet<BigInteger>();
            DFS(0, 1, true, n, produkt);
            Console.WriteLine(produkt.Count);
        }
    }

  static void DFS(int pos, BigInteger produkt, bool tight, string n, HashSet<BigInteger> products)
    {
        if (pos == n.Length)
        {
            products.Add(produkt);
            return;
        }

        int limit = tight ? n[pos] - '0' : 9;
        for (int d = 0; d <= limit; d++)
        {
            bool s = tight && (d == limit);
            BigInteger nextProduct = produkt * d;
            DFS(pos + 1, nextProduct, s, n, products);
        }
    }
}